/*
*       This is an unsupported piece of test code written by Alan Craven
*       of SSD ltd. to aid testing of COMMS links. It is designed to run on
*       an IBM PC-XT with 640k of RAM using COM1 to COM4 as the serial link.
*       If you wish to port this to another machine it should be noted that
*       the code talks directly to hardware addresses. If any problems occur
*       please contact Alan Craven who may be able to help. The code was
*       produced by the BORLAND C++ compiler using their libraries.
*       You will notice that the comments and documentation are minimal!!!
*       This code was evolved rather than planned thus is not well structured.
*       If anybody wishes to try and rectify this I am happy to help with any
*       problems in understanding the code as it exists.
*       GOOD LUCK!!!!
*/
#include	"h:\bc4\include\stdio.h"
#include	<dos.h>
#include	<time.h>
#define STX 0x02
#define ETX 0x03
#define EOT 0x04
#define ENQ 0x05
#define ACK 0x06
#define LF  0x0a
#define CR  0x0d
#define NAK 0x15
#define TRUE 0x20
#define FALSE 0x40
#define LOOPTIME 529.0
int 	COM_STATUS;
int 	COM_DATA;
int 	COM_REG1;
int 	COM_REG2;
char    list,gid,uid;
char    buf[80];
char    buf2[80],txbuf[20],rxbuf[20],*pnt;
char    seqbuf[100][20],filename[80],num[80];
int     i,j,count,maxcount;
float   repcount;
float   getfloat();
FILE    *fopen(),*fp;
int 	main();
void 	ack();
void 	address();
void 	baud();
void 	fast();
void 	format(char *,char *,char,char);
void 	getinput(char *,FILE *);
void 	help();
void 	listing();
void 	nak();
void 	nolist();
void 	oput_reply(char *);
void 	poll(char *,char *);
void 	repeat();
void 	select(char *,char *);
void 	sequence();
void 	sys();
void 	wait_time(float);


int 	main(int argc, char *argv[])
	{
	if(argc==2)
		{
		switch(atoi(argv[1]))
			{
			case 1:
				COM_STATUS=	0x3fd;
				COM_DATA=	0x3f8;
				COM_REG1=	0x3f9;
				COM_REG2=	0x3fb;
				break;
			case 2:
				COM_STATUS=	0x2fd;
				COM_DATA=	0x2f8;
				COM_REG1=	0x2f9;
				COM_REG2=	0x2fb;
				break;
			case 3:
				COM_STATUS=	0x3ed;
				COM_DATA=	0x3e8;
				COM_REG1=	0x3e9;
				COM_REG2=	0x3eb;
				break;
			case 4:
				COM_STATUS=	0x2ed;
				COM_DATA=	0x2e8;
				COM_REG1=	0x2e9;
				COM_REG2=	0x2eb;
				break;
			default :
				printf("Usage: HOST <COM PORT>\n");
				printf("Where COM PORT is a number between 1 and 4\n");
				printf("to use com ports 1 to 4.\n\n\n");
				exit(0);
			}
		}
	else
		{
		COM_STATUS=	0x3fd;
		COM_DATA=	0x3f8;
		COM_REG1=	0x3f9;
		COM_REG2=	0x3fb;
		system("CLS");
		printf("\n\n\n\n\nDefaulting to COM PORT 1.\n\n\n");
		system("PAUSE");
		}
	outp(COM_REG2,0x80);    /* these lines talk directly to the ibm's */
	outp(COM_DATA,0x0c);    /* uart to set it up to be 9600 baud, 7 bit data, */
	outp(COM_REG1,0x00);	/* even parity, 1 start bit & 1 stop bit. */
	outp(COM_REG2,0x1a);
	system("CLS");          /* introduction message */
	printf("                         HOST EMULATOR.\n");
	printf("                         ==============\n");
	printf("                           SSD  LTD.\n");
	printf("                           =========\n\n\n\n");
	printf("Input instrument address > ");/* set up the instrument address */
	getinput(&buf[0],stdin);              /* get initial unit address */
	gid=buf[0];
	uid=buf[1];
	printf("\n");
	list = FALSE;
	for(i=0;i==19;i++)
		{             		/* initialise a few buffers */
		buf[i]=0;
		buf2[i]=0;
		txbuf[i]=0;
		rxbuf[i]=0;
		}
/*
*	This is the main loop which waits for an input line and then calls
*	the relevant handler.
*/
	while(1)
		{
		printf("host>");
		getinput(&buf[0],stdin);
		if(strcmp(&buf[0],"EXIT")==0)
			exit(0);
		if(strcmp(&buf[0],"exit")==0)exit(0);
		else if(strcmp(&buf[0],"ACK")==0)ack();
		else if(strcmp(&buf[0],"ack")==0)ack();
		else if(strcmp(&buf[0],"NAK")==0)nak();
		else if(strcmp(&buf[0],"nak")==0)nak();
		else if(strcmp(&buf[0],"SYS")==0)sys();
		else if(strcmp(&buf[0],"sys")==0)sys();
		else if(strcmp(&buf[0],"LIST")==0)listing();
		else if(strcmp(&buf[0],"list")==0)listing();
		else if(strcmp(&buf[0],"NOLIST")==0)nolist();
		else if(strcmp(&buf[0],"nolist")==0)nolist();
		else if(strcmp(&buf[0],"")==0);              /* catch line feeds */
		else if(strcmp(&buf[0],"HELP")==0)help();
		else if(strcmp(&buf[0],"help")==0)help();
		else if(strcmp(&buf[0],"REP")==0)repeat();
		else if(strcmp(&buf[0],"rep")==0)repeat();
		else if(strcmp(&buf[0],"SEQ")==0)sequence();
		else if(strcmp(&buf[0],"seq")==0)sequence();
		else if(strcmp(&buf[0],"FAST")==0)fast();
		else if(strcmp(&buf[0],"fast")==0)fast();
		else if(strcmp(&buf[0],"SAVE")==0)save();
		else if(strcmp(&buf[0],"save")==0)save();
		else if(strcmp(&buf[0],"LOAD")==0)load();
		else if(strcmp(&buf[0],"load")==0)load();
		else if(strcmp(&buf[0],"BAUD")==0)baud();
		else if(strcmp(&buf[0],"baud")==0)baud();
		else if(buf[0]=='*')address();
		else
/*
*       This bit deals with messages that need to be sent to the slave
*       device.
*/
			{
			if(buf[0]=='#')
				{           /* repeat last command */
				j=send_mess(&txbuf[0]);
				}
			else
				{                     /* format and send a command */
				format(&buf[0],&txbuf[0],gid,uid);
				j=send_mess(&txbuf[0]);
				}
			if(j == 0)
				{                /* look for a reply */
				if(!rcve_reply(&rxbuf[0]))
					{
					if(rxbuf[1] < ACK)
						oput_reply(&rxbuf[2]);
					else
						oput_reply(&rxbuf[1]);
					}
				}
			}
		}
	}
/*
*       A small routine to transmit an ACK to the slave.
*/
void ack()
	{
	char *ptr;
	txbuf[0] = ACK;
	txbuf[1] = (char)NULL;
	ptr = &txbuf[0];
	while(*ptr)
		{
		while(((j=inp(COM_STATUS))&0x0020)==0)
			;/* is ibm uart ready */
		outp(COM_DATA,*ptr++); /* yes so output character */
		}
	if(list == TRUE)
		{
		fprintf(fp,"%c%c        ",gid,uid);
		fprintf(fp,"ACK");
		fputc(0x09,fp);
		fputc(0x09,fp);
		}
	if(!rcve_reply(&rxbuf[0]))
		{
		if(rxbuf[1] < ACK)
			oput_reply(&rxbuf[2]);
		else
			oput_reply(&rxbuf[1]);
		}
	}


void address()               /* change unit address */
	{
	gid=buf[1];
	uid=buf[2];
	printf("\nInstrument address is now %c%c\n\n",gid,uid);
	}


void baud()                  /* set the link baud rate */
	{
	printf("Input required baud rate >");
	getinput(&buf[0],stdin);
	if(strcmp(&buf[0],"110")==0)system("mode com1:110,e,7,2 > null");
	else if(strcmp(&buf[0],"300")==0)system("mode com1:300,e,7,1 > null");
	else if(strcmp(&buf[0],"600")==0)system("mode com1:600,e,7,1 > null");
	else if(strcmp(&buf[0],"1200")==0)system("mode com1:1200,e,7,1 > null");
	else if(strcmp(&buf[0],"2400")==0)system("mode com1:2400,e,7,1 > null");
	else if(strcmp(&buf[0],"4800")==0)system("mode com1:4800,e,7,1 > null");
	else if(strcmp(&buf[0],"9600")==0)system("mode com1:9600,e,7,1 > null");
	system("del null");
	printf("BAUD rate set to %s\n",&buf[0]);
	}

/*
*	Implements fast access to the drive, i.e. it does not send the
*	instrument address for each message in the sequence.
*/
void fast()
	{
	printf("Is fast sequence loaded [y/n]? >");
	getinput(&buf[0],stdin);
	if((buf[0] != 'y')&&(buf[0] != 'Y'))
		{
		count=0;
		for(printf("input fast sequence >"),
			getinput(&buf[0],stdin)
			;
			((strcmp(&buf[0],"END")!=0)&&(strcmp(&buf[0],"end")!=0))
			;
			strcpy(&seqbuf[count][0],&buf[0]),
			printf("input fast sequence >"),
			getinput(&buf[0],stdin),
			count++
			)
				;
		maxcount=count-1;
		}
	printf("Fast - input repeat number >");
	getinput(&num[0],stdin);
	for(repcount=getfloat(&num[0]);repcount>0.0;repcount -= 1.0)
		{
		printf("\nSequence count = %6.0f\n",repcount);
		for(count=0;count<=maxcount;count++)
			{
			strcpy(&buf[0],&seqbuf[count][0]);
			printf("%s\n",&buf[0]);
			if(buf[0] == '*')
				address();
			else
				{
				format(&buf[0],&txbuf[0],gid,uid);
				if(count==0)
					j=send_mess(&txbuf[0]);
				else
					j=send_mess(&txbuf[5]);
				if(j == 0)
					{
					if(!rcve_reply(&rxbuf[0]))
						{
						if(rxbuf[1] < ACK)
							oput_reply(&rxbuf[2]);
						else
							oput_reply(&rxbuf[1]);
						}
					}
				}
			}
		}
	}


void format(mesbuf,txbuf,gid,uid) /* routine that puts the message into either */
char    *mesbuf,*txbuf,gid,uid;     /* select format or poll format */
	{
	*txbuf++ = EOT;
	*txbuf++ =gid;
	*txbuf++ =gid;
	*txbuf++ =uid;
	*txbuf++ =uid;
	if(*mesbuf++ == '?')
		poll(mesbuf,txbuf);  /* put into poll format */
	else
		select(--mesbuf,txbuf);  /* put into select format */
	}


float getfloat(bufpnt) /* gets a floating point number from the input buffer */
char    *bufpnt;
	{
	float   val;
	val = 0.0;
	while(*bufpnt)
		{
		val *= 10.0;
		val += (float)(*bufpnt++ & 0x0f);
		}
	return(val);
	}


void getinput(bufpnt,ifp) /* routine that gets an input line */
char    *bufpnt;
FILE    *ifp;
	{
	while((*bufpnt++ =getc(ifp))!= LF);
	*--bufpnt= (char)NULL;
	}


void help()          /* prints out a help screen */
	{
	system("cls");
	printf("                      IDI HOST EMULATOR.\n");
	printf("                      ==================\n\n");
	printf("COMMANDS\n");
	printf("        BAUD    Allows selection of baud rate for the serial link\n");
	printf("        FAST    As per SEQ but the first message send includes GID and UID\n");
	printf("                and all subsequent messages in the sequence do not.\n");
	printf("        HELP    Displays this screen\n");
	printf("        LIST    All serial I/O is recorded in the filename asked for.\n");
	printf("        LOAD    Allows a sequence of commands to be loaded from a file.\n");
	printf("        NOLIST  Turns of I/O recording.\n");
	printf("        REP     Allows a single command to be repeatedly sent to the slave.\n");
	printf("                It requests a command and a repeat number, range 0 - 999999.\n");
	printf("                The repeat command prompt = rephost>\n");
	printf("        SAVE    Allows a sequence of commands to be saved into a file\n");
	printf("        SEQ     Allows a sequence of commands to be repeatedly sent to the\n");
	printf("                slave. It requests a sequence of commands and a repeat number.\n");
	printf("                Up to 100 commands are allowed in the sequence.\n");
	printf("                The sequence command prompt = input sequence >\n");
	printf("                The sequence terminator is 'END'\n");
	printf("        SYS     Allows user to issue DOS commands.\n");
	printf("        WAITn   Waits for n seconds, where n is an integer, range 0 - 999999\n");
	printf("\n(..more..)\nHIT RETURN TO CONTINUE.....");
	getinput(&buf[0],stdin);
	system("cls");
	printf("                      IDI HOST EMULATOR.\n");
	printf("                      ==================\n\n\n\n");
	printf("COMMANDS\n");
	printf("        #       Repeats the last command sent.\n");
	printf("        *45     Sets the slave address to be 45\n");
	printf("        SS50.0  Sets parameter SS to be 50.0\n");
	printf("        ?SS     Requests the value of parameter SS\n");
	printf("        ES      Sends the command ES with no data\n");
	printf("        ACK     Sends an ACK to the slave\n");
	printf("        NAK     Sends a NAK to the slave\n");
	printf("\n      NOTE:- The host emulator routine is case sensitive.\n");
	printf("\nHIT RETURN TO CONTINUE.....");
	getinput(&buf[0],stdin);
	system("cls");
	printf("                      IDI HOST EMULATOR.\n");
	printf("                      ==================\n\n\n\n");
	}


void listing()        /* allows all i/o to be listed in a file or to a device */
	{
	printf("Input filename >");
	getinput(&filename[0],stdin);
	if((fp = fopen(&filename[0],"w")) == NULL)
		{
		printf("Unable to open file %s\n",&filename[0]);
		}
	list = TRUE;
	}

/*
*	Loads a text file into the sequence buffer.
*/

load()
	{
	printf("Input filename >");
	getinput(&filename[0],stdin);
	if((fp=fopen(&filename[0],"r"))==NULL)
		{
		printf("Unable to open file %s",&filename[0]);
		return(1);
		}
	for(count=0
		;
		((strcmp(&seqbuf[count-1][0],"END")!=0)&&(strcmp(&seqbuf[count-1][0],"end")!=0))
		;
		getinput(&seqbuf[count][0],fp),count++);
	maxcount=count-2;
	fclose(fp);
	return(0);
	}

/*
*	Sends a NAK out to the instrument.
*/
void nak()
	{
	char *ptr;
	txbuf[0] = NAK;
	txbuf[1] = NULL;
	ptr = &txbuf[0];
	while(*ptr)
		{
		while(((j=inp(COM_STATUS))&0x0020)==0)
			;/* is ibm uart ready */
		outp(COM_DATA,*ptr++); /* yes so output character */
		}
	if(list == TRUE)
		{
		fprintf(fp,"%c%c        ",gid,uid);
		fprintf(fp,"NAK");
		fputc(0x09,fp);
		fputc(0x09,fp);
		}
	if(!rcve_reply(&rxbuf[0]))
		{
		if(rxbuf[1] < ACK)
			oput_reply(&rxbuf[2]);
		else
			oput_reply(&rxbuf[1]);
		}
	}


void nolist()        /* switches off listing */
	{
	if(fclose(fp) == -1)
		{
		printf("Unable to close file %s\n",&filename[0]);
		}
	list = FALSE;
	}


void oput_reply(bufpnt) /* output reply onto the terminal */
char    *bufpnt;
	{
	printf("%s\n",bufpnt);
	if(list == TRUE)
		fprintf(fp,"%s\n",bufpnt);
	}


void poll(mesbuf,txbuf) /* put a message into poll format */
char    *mesbuf,*txbuf;
	{
	*txbuf++ =*mesbuf++;
	*txbuf++ =*mesbuf++;
	*txbuf++ = ENQ;
	*txbuf   = NULL;
	}


rcve_reply(bufpnt)   /* this collects the reply from the slave */
char    *bufpnt;
	{
	int     i,k;
	k=0;
	for(i=0;i<7000;i++)
		{     /* message timeout loop */
		if((inp(COM_STATUS))&0x0001)
			{    /* is there a char ready */
			i=0;
			*bufpnt=inp(COM_DATA);   /* if yes then get it */
			if(k)
				return(0);
			if(*bufpnt == ETX)
				{
				k=1;
				*bufpnt= NULL;
				}
			if(*bufpnt == ACK)
				{   /* translate an ACK into a string */
				*bufpnt++ = NULL;
				*bufpnt++ ='A';
				*bufpnt++ ='C';
				*bufpnt++ ='K';
				*bufpnt = NULL;
				return(0);
				}
			if(*bufpnt == NAK)
				{   /* translate a NAK into a string */
				*bufpnt++ = NULL;
				*bufpnt++ ='N';
				*bufpnt++ ='A';
				*bufpnt++ ='K';
				*bufpnt = NULL;
				return(0);
				}
			if(*bufpnt == EOT)
				{   /* translate an EOT into a string */
				*bufpnt++ = NULL;
				*bufpnt++ ='E';
				*bufpnt++ ='O';
				*bufpnt++ ='T';
				*bufpnt = NULL;
				return(0);
				}
			bufpnt++;
			}
		}
	printf("Message timeout \n\n"); /* no message received */
	if(list == TRUE)
		fprintf(fp,"Message timeout\n");
	return(1);
	}


void repeat()     /* repeats a single command 'repcount' times */
	{
	printf("rephost>");
	getinput(&buf[0],stdin);
	if(buf[0] != '#')
		format(&buf[0],&txbuf[0],gid,uid);
	printf("rephost - input repeat number >");
	getinput(&num[0],stdin);
	for(repcount=getfloat(&num[0]);repcount>0.0;repcount -= 1.0)
		{
		j=send_mess(&txbuf[0]);
		if(j == 0)
			{
			if(!rcve_reply(&rxbuf[0]))
				{
				if(rxbuf[1] < ACK)
					oput_reply(&rxbuf[2]);
				else
					oput_reply(&rxbuf[1]);
				}
			}
		}
	}

/*
*	Saves the contents of the sequence buffer as a text file.
*/
save()
	{
	printf("Input file name >");
	getinput(&filename[0],stdin);
	if((fp=fopen(&filename[0],"w"))==NULL)
		{
		printf("Unable to open file %s\n",&filename[0]);
		return(1);
		}
	for(count=0;count<=maxcount;count++)
		{
		fprintf(fp,"%s",&seqbuf[count][0]);
		fprintf(fp,"\n");
		}
	fprintf(fp,"END\n");
	fclose(fp);
	return(0);
	}


void select(mesbuf,txbuf) /* put a message into select format */
char    *mesbuf,*txbuf;
	{
	*txbuf++ = STX;
	while(*mesbuf)
		*txbuf++ = *mesbuf++;
	*txbuf++ = ETX;
	*txbuf   = NULL;
	}


send_mess(bufpnt)   /* this outputs the message on an RS232 link */
char    *bufpnt;
	{
	int     i;
	char    bcc,*ptr;
	float   time;
	ptr = bufpnt;
	while((*ptr!=STX)&&(*ptr!=ENQ))
		ptr++;
	ptr++;
	i=0;
	time = 0.0;
	if((*ptr == 'W')||(*ptr == 'w'))
		{  /* this bit detects wait commands */
		ptr++;
		if((*ptr == 'A')||(*ptr == 'a'))
			{
			ptr++;
			if((*ptr == 'I')||(*ptr == 'i'))
				{
				ptr++;
				if((*ptr == 'T')||(*ptr == 't'))
					{
					ptr++;
					while(*ptr)
						{
						if(*ptr != ETX)
							{
							time += (float)(*ptr & 0x0f);
							time *= 10.0;
							}
						ptr++;
						}
					time /= 10.0;
					wait_time(time);
					return(1);
					}
				}
			}
		}
	bcc=0;  /* if not a wait it is output and a bcc is calculated */
	while(*bufpnt)
		{
		if(i)
			bcc=bcc^*bufpnt;
		if(*bufpnt== STX)
			i=1;
		while(((inp(COM_STATUS))&0x0020)==0)
			;/* is ibm uart ready */
		outp(COM_DATA,*bufpnt++); /* yes so output character */
		}
	bufpnt--;
	if(i)
		{     /* if not a poll then output the bcc */
		while(((inp(COM_STATUS))&0x0020)==0)
			;
		outp(COM_DATA,bcc);
		}
	if(list == TRUE)
		{
		fprintf(fp,"%c%c        ",gid,uid);
		fprintf(fp,"%s",&buf[0]);
		fputc(0x09,fp);
		fputc(0x09,fp);
		}
	return(0);
	}


void sequence()   /* repeats a sequence of commands 'repcount' times */
	{
	printf("Is sequence loaded ? [y/n]>");
	getinput(&buf[0],stdin);
	if((buf[0] != 'y')&&(buf[0] != 'Y'))
		{
		count=0;
		for(printf("input sequence >"),
			getinput(&buf[0],stdin)
			;
			((strcmp(&buf[0],"END")!=0)&&(strcmp(&buf[0],"end")!=0))
			;
			strcpy(&seqbuf[count][0],&buf[0]),
			printf("input sequence >"),
			getinput(&buf[0],stdin),
			count++
			)
				;
		maxcount=count-1;
		}
	printf("seqhost - input repeat number >");
	getinput(&num[0],stdin);
	for(repcount=getfloat(&num[0]);repcount>0.0;repcount -= 1.0)
		{
		printf("\nSequence count = %6.0f\n",repcount);
		for(count=0;count<=maxcount;count++)
			{
			strcpy(&buf[0],&seqbuf[count][0]);
			printf("%s\n",&buf[0]);
			if(buf[0] == '*')
				address();
			else
				{
				format(&buf[0],&txbuf[0],gid,uid);
				j=send_mess(&txbuf[0]);
				if(j == 0)
					{
					if(!rcve_reply(&rxbuf[0]))
						{
						if(rxbuf[1] < ACK)
							oput_reply(&rxbuf[2]);
						else
							oput_reply(&rxbuf[1]);
						}
					}
				}
			}
		}
	}


void sys()    /* outputs a DOS command */
	{
	printf("Input command >");
	getinput(&buf[0],stdin);
	system(&buf[0]);
	}


void wait_time(float time)  /* waits in this routine for "time" seconds */
	{
	float   loop;
	clock_t start;
	clock_t time_now;
	printf("WAITING FOR = %1.0f SECONDS.\n",time);
	while(time > 0.0)
		{
		start = clock();
		time_now = clock();
		while(time_now < start+18)
			{
			time_now = clock();
			}
		time -= 1.0;
		printf("%c%6.0f",CR,time);
		fflush(stdout);
		}
	printf("\n");
	}